% Schrodinger Waves at One Specific Time
clear; clf;
% initial values in atomic units
hbar=1;      %constant of angular momentum
m=1;         % mass of an electron
t=0;         % time
p0=2;        % initial momentum in atomic units
sp=0.6;      % uncertainty in momentum

% loop defining positions
jmax=500;
for j=1:jmax
    x(j)=(j/jmax)*120-60;
end
dx=x(2)-x(1); % position increment
% loop defining momenta, corresponding kinetic energies, and weight.
% They are defined relative to the initial momentum p0
nmax=500;
for n=1:nmax
    p(n)=2*p0*n/nmax;  % momentum
    E(n)=p(n)^2/(2*m); % energy
    w(n)=exp(-(p(n)-p0)^2/(4*sp^2));  % weight
end
% define Schrodinger waves in terms of energy, momentum, time, position
for n=1:nmax
    for j=1:jmax
        psi(j,n)=exp((-1i/hbar)*(E(n)*t-p(n)*x(j)));
    end
end


figure(1)
subplot(2,1,1)
% calculate Schrodinger waves for chosen momenta [variable ps not psi]
        for j=1:jmax
            for n=1:18
                ps(j,n)=w(n*25)*exp((-i/hbar)*(E(n*25)*t-p(n*25)*x(j)));
            end
        end
% plot with offsets
for n=1:18
    plot(x,real(ps(:,n))+2.5*n,'k')
    hold on
end
    text(-60,55,'a)','FontSize',18)
    set(gca,'FontSize',14)
    xlabel('Position (Bohr)','FontSize',16)
    ylabel('Amplitude with Offset','FontSize',16)

% sum the waves at any value of time (t)

for n=1:nmax
    for j=1:jmax
        psi(j,n)=exp((-i/hbar)*(E(n)*t-p(n)*x(j)));
    end
end
% weighted sum of waves
for j=1:jmax
    s=0;
    for n=1:nmax
        s=s+w(n)*psi(j,n);
    end
    psisum(j)=s;
end
% Normalize wavefunction
N=0;
for j=1:jmax
    N=N+psisum(j).*conj(psisum(j))*dx;
end
N
psisum=psisum./N^.5;

subplot(2,1,2)
plot(x,real(psisum),'k','LineWidth',1)
%plot(x,imag(psisum),'b','LineWidth',1)
%plot(x,psisum.*conj(psisum),'k','LineWidth',2)
text(-60,0.9,'b)','FontSize',18)
set(gca,'FontSize',12)
xlabel('Position (Bohr)','FontSize',16)
ylabel('Amplitude','FontSize',16)

set(gcf,'PaperUnits','inches','PaperPosition',[0 0 6 10]);
print(1,'-dtiff','-r600','Adding_matter_waves_t0.tif')

