% complex numbers are used for waves
E=-1; % energy in atomic units
hbar=1; % atomic units
t=0:.1:50; % define a time range (in atomic units)
theta=-E*t/hbar;  % give theta in terms of E, t, and Hbar
f=exp(1i*theta); % temporal part of wavefuntion vs time
figure(1)
plot(t,real(f),'r',t,imag(f),'b')
xlabel('Time (Atomic Units)','FontSize',16)
ylabel('Amplitude','FontSize',16)
set(gca,'FontSize',14)
% set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 3]);
% print(1,'-dtiff','-r600','complex_number_as_waves.tif')

