% Modeling a Lorentzian function with Particle-in-a-Box Basis
a=14; % width of box
x0=5.5*a/10; % position of Lorentzian
d=a/25; % half-width-at-half-max of Lorentzian
x1=0:.05:a; % gridded row array of x variable for plotting
y1= 1./(1+((x1-x0)/d).^2); % digital fit function

% calculate the coefficient for each basis function
N=50; % number of basis sets
yfit=0*x1; % initialize the y values
for i=1:N
    fun=@(x)  sqrt(2/a)*sin(i*pi*x/a).*(1./(1+((x-x0)/d).^2)) ;
    c(i)= integral(fun,0,a); % each coefficient
    yfit=yfit+c(i)*sqrt(2/a)*sin(i*pi*x1/a); % add cont. of each basis fun.
end

figure(1)
subplot(2,1,2)
plot(x1,y1,'r') % plot the Lorentzian
hold on
plot(x1,yfit,'b') % plot the basis set model
xlabel('x','FontSize',14)
ylabel('Amplitude','FontSize',14)
set(gca,'FontSize',12)
subplot(2,1,1)
for i=1:N
    plot(x1,c(i)*sqrt(2/a)*sin(i*pi*x1/a)+i*0.2)
    hold on
end
xlabel('x','FontSize',14)
ylabel('Amplitude','FontSize',14)
set(gca,'FontSize',12)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 4 8])
print(1,'-dtiff','-r600',['weighted_basis_functions_',num2str(N),'.tif']) 

