clear; clf;
% DVRgeneral, Discrete Variable Representation, Finite Well
% J.V.Coe, 8/23/2012, modified 1/8/2018
% D.T. Colbert and W.H. Miller, J. Chem. Phys. 96, 1982-91 (1992).
% All atomic units
hbar=1; % hbar in atomic units
mu=12759.4; % mass in electron masses, 7.000 daltons 
%  ********** define grid of independent variable ********************
imax=500; % number of steps along independent coordinate
xmin=1.5; % min value of independent coordinate
xmax=2.5; % max value of independent coordinate
dx=(xmax-xmin)/imax; % increment, step size 
x=xmin+dx:dx:xmax; % define grid of x-variable, start:step:end
gp=hbar^2/(2*mu*dx^2); % calculate grid parameter
% ********** input the potential function *****************************
k=1.473; % Hooke's Law Force constant
re=2.0743; % equilibrium bond distance in bohr
for i=1:imax
    V(i)=0.5*k*(x(i)-re)^2; % parabolic potential
end
% ********** kinetic energy matrix ************************************
T=zeros(imax,imax);
for i=1:imax
    for ip=1:imax
        T(i,ip)=gp*(pi^2)/3.0;
        if(ip~=i)
        T(i,ip)=gp*((-1)^(i-ip))*2/((i-ip)^2);
        end
    end
end
% **********  potential energy matrix ********************************
Vh=zeros(imax,imax);
for i=1:imax
    for ip=1:imax
        if(i==ip)
            Vh(i,ip)=V(i);
        end
    end
end
% ********** Hamiltonian *********************************************
H=T+Vh;
% ********** Digonalize Hamiltonian **********************************
% Calculate eigenvalues (on diagaonal of E1) and
% eigenvectors as columns of P
[P,E1]=eig(H);
% Pick off the eigenvalues
E=diag(E1);
% ********** Normalization of Wavefunctions *************************
N=0;
for i=1:imax
    N=N+conj(P(i,1))*P(i,1)*dx;
end
disp(['check for normalization, N= ',num2str(N)])
% normalize wavefunctions
P=P./(N^0.5);
% check for normalization
s=0;
for i=1:imax
    s=s+conj(P(i,1))*P(i,1)*dx;
end
disp(['after nomalization, N= ',num2str(s)])
% ********** Plot the results ***************************************
ps=0.0025; % pick a wavefunction amplitude scaling factor
nE=6; % pick the number of energy levels to plot
for n=1:nE % choose the number of states to plot 
    plot(x(:),V(:),'r')
    hold on
    plot(x(:),E(n,1)*ones(imax),'-g') % green energy level lines
    hold on
    plot(x(:),real(P(:,n))*ps+E(n,1),'b') % modify wavefunction amplitude
    hold on
end
axis([1.5 2.5 -0.005 0.07]) % scale the plot
set(gca,'FontSize',12)
xlabel('r (bohr)','FontSize',14,'Interpreter','latex')
ylabel('$Re{\psi} \,(1/\surd bohr)\,or\, E (hartree)$','Interpreter','latex')
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(1,'-dtiff','-r600','DVR_N2_re.tif') 

