clear; clf;
% DVRgeneral, Discrete Variable Represenstation
% J.V.Coe, 1/21/2014
% D.T. Colbert and W.H. Miller, J. Chem. Phys. 96, 1982-91 (1992).
% All atomic units
hbar=1; % hbar in atomic units
mu=1; % reduced mass in electron masses
% x coordinate (get grid points on box)
nx=50; % number of steps along x coordinate
a=10; % box from 0 to a
dx=2*a/nx; % x increment, step size in position 
% determine the value of x at each step
for i=1:nx
    x(i)=i*dx-a/2-dx/2;
end
% y coordinate
ny=50; % number of steps along y coordinate
b=10; % box from 0 to b
dy=2*b/ny; % y increment, step size in position 
% determine the value of y at each step
for j=1:ny
    y(j)=j*dy-b/2-dy/2;
end
% input the potential function
V0=1000; % well depth 
for i=1:nx
    for j=1:ny
        V(i,j)=V0;
        if(0<=x(i)&&x(i)<=a&&0<=y(j)&&y(j)<=b)
        V(i,j)=0;
        end
    end
end

% grid parameters
gpx=hbar^2/(2*mu*dx^2); % x grid parameter
gpy=hbar^2/(2*mu*dy^2); % y grid parameter
% kinetic energy matrices
Tx=zeros(nx,nx);
for i=1:nx
    for ip=1:nx
        Tx(i,ip)=gpx*(pi^2)/3.0;
        if(ip~=i)
        Tx(i,ip)=gpx*((-1)^(i-ip))*2/((i-ip)^2);
        end
    end
end
Ty=zeros(ny,ny);
for j=1:ny
    for jp=1:ny
        Ty(j,jp)=gpy*(pi^2)/3.0;
        if(jp~=j)
        Ty(j,jp)=gpy*((-1)^(j-jp))*2/((j-jp)^2);
        end
    end
end

% Hamiltonian
H=zeros(nx*ny,nx*ny);
for i=1:nx
    for j=1:ny
        for ip=1:nx
            for jp=1:ny
                n=(j-1)*nx+i;
                np=(jp-1)*nx+ip;
                if(j==jp)
                    H(n,np)=Tx(i,ip);
                end
                if(i==ip)
                    H(n,np)=H(n,np)+Ty(j,jp);
                end
                if(i==ip&&j==jp)
                    H(n,np)=H(n,np)+V(i,j);
                end
            end
        end
    end
end
        
% Calculate eigenvalues (on diagaonal of E1) and
% eigenvectors as columns of P
[P,E1]=eig(H);
% Pick off the eigenvalues from diagonal
E=diag(E1);

% Plot Results
plin=P(:,1);
psi1=reshape(plin,nx,ny);
figure(1)
surfl(-psi1)
view(45,45)
xlabel('X (Bohr)','Fontsize',14)
ylabel('Y (Bohr)','Fontsize',14)
zlabel('Amplitude','Fontsize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(1,'-dtiff','-r600','psi1_2D.tif')

plin=P(:,2);
psi2=reshape(plin,nx,ny);
figure(2)
surfl(psi2)
view(45,45)
xlabel('X (Bohr)','Fontsize',14)
ylabel('Y (Bohr)','Fontsize',14)
zlabel('Amplitude','Fontsize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(2,'-dtiff','-r600','psi2_2D.tif')

plin=P(:,3);
psi3=reshape(plin,nx,ny);
figure(3)
surfl(psi3)
view(45,45)
xlabel('X (Bohr)','Fontsize',14)
ylabel('Y (Bohr)','Fontsize',14)
zlabel('Amplitude','Fontsize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(3,'-dtiff','-r600','psi3_2D.tif')

plin=P(:,4);
psi4=reshape(plin,nx,ny);
figure(4)
surfl(psi4)
view(45,45)
xlabel('X (Bohr)','Fontsize',14)
ylabel('Y (Bohr)','Fontsize',14)
zlabel('Amplitude','Fontsize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(4,'-dtiff','-r600','psi4_2D.tif')

plin=P(:,5);
psi5=reshape(plin,nx,ny);
figure(5)
surfl(psi5)
view(45,45)
xlabel('X (Bohr)','Fontsize',14)
ylabel('Y (Bohr)','Fontsize',14)
zlabel('Amplitude','Fontsize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(5,'-dtiff','-r600','psi5_2D.tif')

plin=P(:,6);
psi6=reshape(plin,nx,ny);
figure(6)
surfl(psi6)
view(45,45)
xlabel('X (Bohr)','Fontsize',14)
ylabel('Y (Bohr)','Fontsize',14)
zlabel('Amplitude','Fontsize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(6,'-dtiff','-r600','psi6_2D.tif')
