clear;
% Free Particle, all atomic units
x=[-6:.1:40]'; % range of position in Bohr
x0=0; % initial position
hbar=1;
m=1; % mass of an electron
p0=3;  % initial momentum
s=1.5; % width parameter
dx=s/sqrt(2); disp(['dx= ',num2str(dx)]) % position uncertainty
dp=hbar/(sqrt(2)*s); disp(['dp= ',num2str(dp)]) % momentum uncertainty
% loop through time
for i=1:8
    t(i)=i;
    xbar(i)=x0+p0*t(i)/m; % expectation value of position
    psi(:,i)= 1/(  pi^(1/4)*sqrt(s*(1+1i*hbar*t(i)/(m*s^2))))*...
        exp(-(x-x0-p0*t(i)/m).^2/(2*s^2*(1+1i*hbar*t(i)/(m*s^2)))).*...
        1i.*exp(1i*(p0*x-p0^2*t(i)/(2*m))/hbar); % wavepacket
end
% make a 3D plot
figure(1)
tone=x*0+1; % column array for time that matches x and psi
for i=1:8
    plot3(x,tone*t(i),conj(psi(:,i)).*psi(:,i))
    hold on
    plot3(xbar(i),t(i),0,'.k','MarkerSize',12)
end
xlabel('Position (bohr)','FontSize',14,'rot',18)
ylabel('Time (aut)','FontSize',14,'rot',-32)
zlabel('\psi*\psi','FontSize',14)
set(gca,'FontSize',12)
set(gca,'ydir','reverse')
zlim([0 .35])
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 6 6])
print(1,'-dtiff','-r600','free_particle_2.tif') 
