% input the results of Gaussian 03 Calculation on HF at CCSD/cc-pvdz level
% by columns:  step   r(ang)  HF   MP2  MP3  CCSD   
a=xlsread('HF_ccsd_pes.xlsx'); % input the results
a(:,2)=a(:,2)*1e-10/5.2917721092e-11; % convert angstroms to bohr
Edissociation=-0.4992784-99.5266899; % ab initio on H and F as doublets

% fit the area at bottom of well (9 points) to a quadratic
x1=a(10:18,2); % independent variable
y1=a(10:18,6); % dependent variable
% Define and Perform Toolbox Nonlinear Least Squares Fit 
b10=[0.147 1.8 -100.22] % choose initial fit parameters
fun=@(b1,x) 0.5*b1(1)*(x-b1(2)).^2+b1(3) % define fit function
mdl1 = NonLinearModel.fit(x1,y1,fun,b10); % MATLAB toolbox function
mdl1 % report results in command window
yfit1=mdl1.Fitted; % extract fitted values of y
bfit1=mdl1.Coefficients.Estimate; % extract fit parameters
bfitSE1=mdl1.Coefficients.SE; % extract fit parameter uncertainties
xq1=[1.2:.05:2.3]'; % range for line fit curve
yq1=0.5*bfit1(1)*(xq1-bfit1(2)).^2+bfit1(3); % fitted curve over range
 
% fit to a Morse potential
x2=a(5:41,2); % independent variable
y2=a(5:41,6); % dependent variable 
% Define and Perform Toolbox Nonlinear Least Squares Fit 
b20=[0.23 1.1 1.7 -100.22]; % choose initial fit parameters
fun=@(b2,x) b2(1)*(1-exp(-b2(2)*(x-b2(3)))).^2+b2(4) % define fit function
mdl2 = NonLinearModel.fit(x2,y2,fun,b20); % MATLAB toolbox function
mdl2 % report results in command window
yfit2=mdl2.Fitted; % fitted values of y
bfit2=mdl2.Coefficients.Estimate; % fit parameters
bfitSE2=mdl2.Coefficients.SE; % fit parameter uncertainties

% Plot Results
figure(1)
plot([0 5], [Edissociation Edissociation],'--k','LineWidth',0.9)
hold on
plot(xq1,yq1,'--r') % plots harmonic fit as line beyond range
hold on
plot(x2,yfit2,'-g','LineWidth',1.3) % plots Morse fit line
hold on
plot(x1,yfit1,'r','LineWidth',3) % plots harmonic fit points
hold on
plot(a(2:41,2),a(2:41,6),'.k','MarkerSize',11) % plots ab intio results
text(3.1,-100.017,'H+F','FontSize',18)
text(1.2,-100.22,'HF','FontSize',18)
axis([0 3.5 -100.25 -99.99]) % set range of plot 
set(gca,'FontSize',14) % swet tick label size
xlabel('r (bohr)','FontSize',16) % label x-axis
ylabel('E (hartree)','FontSize',16) % label y-axis
% set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 4])
% print(1,'-dtiff','-r600','HF_pes_ccsd.tif') 