% input H atom transitions from NIST
% wavelength(nm) error  wavenumber n k
a=xlsread('HI_observed_reduced.xlsx');
lam=a(:,1); % wavelength in nm
dlam=a(:,2); % error in wavelength in nm
wav=10^7./lam; % wavelength converted to wavenumbers
dwav=10^7*dlam./lam.^2; % error converted to wavenumbers
check=wav-a(:,3); % check of calculated to input

x=a(:,4).^-2-a(:,5).^-2; % extract the x variable from 1st column
Y=wav; % extract the y variable from 2nd column
er=dwav; % extract error
[N nc]=size(a); % get the number of points to fit
% create X matrix
M=1; % # of fit parameters, one column in X for each
X(:,1)=x; % 1st column of X
 
W=eye(N);  % creat an initial weight matrix
for i=1:N
    W(i,i)=1/er(i,1)^2; % fill with individual weights
end
B=inv(X'*W*X)*X'*W*Y; % calculate fit parameters
Yfit=X*B; % calculate y values
Sy=sqrt((Y-Yfit)'*(Y-Yfit)/(N-M)); % get Sy, standard deviation in y
MSE=abs((Y'*W*Y-Y'*W*Yfit)/(M-N)); % get MSE
dB=diag(sqrt(MSE*inv(X'*W*X))); % get errors in B parameters
 
% plot and output results
figure(1)
errorbar(x,Y,er,'.k','MarkerSize',12) % plot original data
hold on
plot(x,Yfit,'-r','LineWidth',1.5) % plot fitted data
xlabel('x','FontSize',14)
ylabel('Y','FontSize',14)
set(gca,'FontSize',12)
% output the fit parameters and uncertainties
disp('fit paramters and uncertainties')
for i=1:M
    disp(['b(',num2str(i),')= ',num2str(B(i)),' +/- ',num2str(dB(i))])
end
% output the standard deviation of the fit
disp(['Standard Deviation in y, Sy= ',num2str(Sy)])
disp(['mean Square Error, MSE= ',num2str(MSE)])
disp(['square root of MSE= ',num2str(sqrt(MSE))]) % same as Sy
% set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 6])
% print(1,'-dtiff','-r600','fit_H_atom.tif')

Rinf=109737.31568639;  %Hanch Rinf in 1997 (91)

%Rinf=109737.568;
mp=1.67262192369e-27;
me=9.10938356e-31;

format long
% RH in cm-1 from Rinf
Rinf*mp/(me+mp)
% RH in Hartree from constants
0.5*mp/(me+mp)
% Rh in atomic units
0.5*mp/(me+mp)/(2*pi*137.0359990)
% Rh to cm-1 from atomic units
0.5*mp/(me+mp)/(2*pi*137.0359990)/5.2917721092e-11/100