clear; clf;
% Particle-in-a-Box, all atomic units
L=10; % initial position
x=[0:.01:L]'; % range of position in Bohr
hbar=1;
m=1; % mass of an electron
nx=1;
E=(1/(2*m))*(nx*pi*hbar/L)^2;
% loop through time
ntimesteps=50;
for i=1:ntimesteps
    t(i)=4*i;
    psi(:,i)=(sqrt(2/L))*sin(nx*pi*x/L)*exp(-1i*E*t(i)/hbar);
end

% make a 3D plot
figure(1)
tone=x*0+1; % column array for time that matches x and psi
subplot(2,1,1)
for i=1:ntimesteps
    plot3(x,tone*t(i),conj(psi(:,i)).*psi(:,i))
    hold on
end
view(-44,60)
xlabel('Position (bohr)','FontSize',14,'rot',28)
ylabel('Time (aut)','FontSize',14,'rot',-31)
zlabel('\psi*\psi','FontSize',14)
set(gca,'FontSize',12)
set(gca,'ydir','reverse')
subplot(2,1,2)
for i=1:ntimesteps
    plot3(x,tone*t(i),real(psi(:,i)));
    hold on
end
view(-44,60)
xlabel('Position (bohr)','FontSize',14,'rot',28)
ylabel('Time (aut)','FontSize',14,'rot',-31)
zlabel('Re(\psi)','FontSize',14)
set(gca,'FontSize',12)
set(gca,'ydir','reverse')
%zlim([0 .35])
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 8])
print(1,'-dtiff','-r600','particle_in_a_Box_time.tif') 
