% three dimensional particle in a box
clear; clf; 
a=10; b=10; c=10; % length of the box in x, y, and z in bohr
nx=2; ny=1; nz=1; % choose quantum numbers
p=6e-6; % (prob. being in a grid unit)/(dx*dy*dz)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
n=50;  % number of grid units along x, y, or Z directions
dx=a/n; dy=b/n; dz=c/n; % grid unit length in x, y, and z
x=[0+a/n:a/n:a-a/n]; % array along x
y=[0+b/n:b/n:b-b/n]; % array along y
z=[0+c/n:c/n:b-c/n]; % array along z
[X Y Z]=meshgrid(x,y,z); % get a three dimensional grid
fx=(2/a)*(sin(nx*pi*X/a).^2)*dx; % x contribution to grid unit prob.
fy=(2/b)*(sin(ny*pi*Y/b).^2)*dy; % y contribution to grid unit prob.
fz=(2/c)*(sin(nz*pi*Z/c).^2)*dz; % z contribution to grid unit prob.
P=fx.*fy.*fz;  % probability of being in 3D grid unit
m=0; % initiate index for grid units near threshold (line 4) 
for i=1:n-1 % loop through x arrray
    for j=1:n-1 % loop through y arrray
        for k=1:n-1 % loop through z arrray
            if P(i,j,k)>0.8*p & P(i,j,k)<1.2*p; % prob near threshold?
                m=m+1; % increment index
                xm(m,1)=X(i,j,k); % get x coord 
                ym(m,1)=Y(i,j,k); % get y coord 
                zm(m,1)=Z(i,j,k); % get z coord 
            end
        end
    end
end

figure(1)
axis equal;
plot3(xm,ym,zm,'.b','MarkerSize',6)
set(gca,'FontSize',14)
xlabel('X (bohr)','FontSize',16)
ylabel('Y (bohr)','FontSize',16)
zlabel('Z (bohr)','FontSize',16)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
print(1,'-dtiff','-r600',['3d_box_',num2str(nx),'_',...
    num2str(ny),'_',num2str(nz),'.tif'])
