clear
% all atomic untis
hbar=1;
a=10; % Bohr
n=1; % quantum number of state
m=1; % mass of particle in electron masses
E=n^2*(hbar^2)*(2*pi)^2/(8*m*a^2); %Energy of state in Hartrees
E  % in Hartrees
tp=2*pi*hbar/E; %period in atomic units of time
tp  % 2.419x10-17 s = 1 atomic unit of time
'2.419x10-17 s = 1 atomic unit of time'
% calculate wavefunction at a set of times
for i=1:100
        x(i)=(i/100)*a;
            for j=1:1000
                t(j)=(j/200)*tp*5;
                psi_real(i,j)=sqrt(2/a)*sin(n*pi*x(i)/a)*cos(E*t(j)/hbar);
                psi_img(i,j)=sqrt(2/a)*sin(n*pi*x(i)/a)*sin(E*t(j)/hbar);
                psistar_psi(i,j)=(sqrt(2/a)*sin(n*pi*x(i)/a))^2;
            end
end
 
% plot
figure(1)
for j=1:100
    subplot(3,1,1)
    plot(x(1,:),psi_real(:,j),'r')
    ylabel('Real(Psi) Bohr^-1/2')
    axis([0 10 -.5 .5])
    subplot(3,1,2)
    plot(x(1,:),psi_img(:,j),'b')
    ylabel('Imag(Psi) Bohr^-1/2')
    axis([0 10 -.5 .5])
    subplot(3,1,3)
    plot(x(1,:),psistar_psi(:,j),'g')
    axis([0 10 -.5 .5])
    xlabel('Position (Bohr)')
    ylabel('Psi*Psi Bohr^-1')
    drawnow
end


