r=[0:.1:5]'; % define range of radial coordinate
a=1.0005; % a constant is almost the Bohr radius
psi=(1/sqrt(pi*a^3))*exp(-r/a); % define 1s full wavefunction
R=(2*a^(3/2))*exp(-r/a); % define the radial wavefunction

figure(1)

subplot(1,2,1)
plot(r,psi.*psi,'k','LineWidth',2) % plot (psi*)psi
set(gca,'FontSize',12)
xlabel('r (bohr)','FontSize',16,'Interpreter','latex')
ylabel('${\psi}^{*}{\psi}$','FontSize',18,'Interpreter','latex')
axis([0 5 0 0.35]) % scale the plot

subplot(1,2,2)
plot(r,R.*R.*r.^2,'k','LineWidth',2) % plot radial dist. function
hold on
plot([1 1],[0 0.6],'--k')
set(gca,'FontSize',12)
xlabel('r (bohr)','FontSize',16,'Interpreter','latex')
ylabel('${R}^{*}{R}r^{2}$','FontSize',16,'Interpreter','latex')
axis([0 5 0 0.6]) % scale the plot
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 3])
print(1,'-dtiff','-r600','psi_star_psi_vs_R_star_R.tif') 

