clear;
%input Sirius emission spectrum
a=dlmread('sirius.txt');
x1=a(:,1)*1e-10;
y1=a(:,2);
i=[20 52 107 118 186 246 337 441 521 706 870 938 1007]; % background points
x=x1(i,1); % independent variable in first column of a
y=y1(i,1); % dependent variable in 2ns column of a
[N nc]=size(x); % get the number of points N
W=eye(N,N);  % Weights are unknown, W is identity matrix
M = 6; % input the number of terms, % degree of polynomial is M-1
% Create an X matrix, polynomial up to M-1 power
for j=1:M % for each column of X
    X(:,j)=x.^(j-1);
end
% perform fit
B=inv(X'*W*X)*X'*W*y; % calculate fit parameters
% B=inv(X'.*W.*X).*X'.*W.*y; % calculate fit parameters
yfit=X*B; % calculate y values 
Sy=sqrt((y-yfit)'*(y-yfit)/(N-M)); % get Sy, standard deviation in y
MSE=abs((y'*W*y-y'*W*yfit)/(M-N)); % get MSE
dB=diag(sqrt(MSE*inv(X'*W*X))); % get errors in B parameters

y1fit=0*y1;
for j=1:M
    y1fit=y1fit+B(j)*x1.^(j-1);
end

for j=1:M
    disp(['b(',num2str(j),')= ',num2str(B(j)),'+/- ',num2str(dB(j))])
end
disp(['Sy= ',num2str(Sy)]) 

% input emission spectrum of Vega
aV=dlmread('vega.txt');
x1V=aV(:,1)*1e-10;
y1V=aV(:,2);
xV=x1V(i,1);
yV=y1V(i,1);

for j=1:M % for each column of X
    XV(:,j)=xV.^(j-1);
end
% perform fit
BV=inv(XV'*W*XV)*XV'*W*yV; % calculate fit parameters
yVfit=XV*BV; % calculate y values
SyV=sqrt((yV-yVfit)'*(yV-yVfit)/(N-M)); % get Sy, standard deviation in y
MSE=abs((yV'*W*yV-yV'*W*yVfit)/(M-N)); % get MSE
dBV=diag(sqrt(MSE*inv(XV'*W*XV))); % get errors in B parameters

yV1fit=0*y1;
for j=1:M
    yV1fit=yV1fit+BV(j)*x1V.^(j-1);
end

for j=1:M
    disp(['bV(',num2str(j),')= ',num2str(BV(j)),'+/- ',num2str(dBV(j))])
end
disp(['SyV= ',num2str(Sy)]) 

figure(1)
subplot(1,2,1)
plot(x1,y1,'b')
hold on
plot(x,y,'.g','MarkerSize',15)
hold on
plot(x1,y1fit,'-g')
xlabel('Wavelength (m)','FontSize',14)
ylabel('Relative Intensity','FontSize',14)
text(4.6e-7,1,'Sirius','FontSize',16,'Color',[0 0 1])
set(gca,'FontSize',12)
axis([min(x1) max(x1) 0.2 1.5]) 

subplot(1,2,2)
plot(x1V,y1V,'r')
hold on
plot(xV,yV,'.g','MarkerSize',15)
hold on
plot(x1V,yV1fit,'-g')
axis([min(x1V) max(x1V) 0.5e5 5e5])
text(4.5e-7,3e5,'Vega','FontSize',16,'Color',[1 0 0])
xlabel('Wavelength (m)','FontSize',14)
ylabel('Relative Intensity','FontSize',14)
set(gca,'FontSize',12)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 4])
print(1,'-dtiff','-r600','Sirius_Vega_emission.tif')
  
figure(2)
y1fit_abs=-log(y1./y1fit);
yV1fit_abs=-log(y1V./yV1fit);
plot(x1,y1fit_abs,'b')
hold on
plot(x1V,yV1fit_abs,'r')
axis([min(x1) max(x1) -0.1 1.5])
xlabel('Wavelength (m)','FontSize',14)
set(gca,'FontSize',12)
ylabel('Absorbance','FontSize',14)
text(4.5e-7,0.8,'Sirius','FontSize',16,'Color',[0 0 1])
text(4.5e-7,0.5,'Vega','FontSize',16,'Color',[1 0 0])
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 2])
print(2,'-dtiff','-r600','Sirius_Vega_absorption.tif')

