% Contour Plots of Spherical Harmonic Functions - J.V. Coe 1/6/2014
% Change L and M manually
% Based on a function written by DBE 2005/09/30 
%
% note:  conversion to cartesian coordinates requires that THETA be offset 
% by pi/2 or it only plots half of contour
%
clear;clf; % clear previous plots
% Pick L and M
L=1;   % orbital angular momentum quantum number
M=1;   % projection of orbital angular momentum quantum number

RES=[55 55]; % resolution of the plot
PHI=linspace(0,2*pi,RES(1));  % Azimuthal - rotation about Z-axis
THETA  =linspace(0,  pi,RES(2));  % Altitude - tilt from z-axis
[PHI,THETA]=ndgrid(PHI,THETA);
Lmn=legendre(L,cos(THETA)); % Legendre function
if L~=0
  Lmn=squeeze(Lmn(M+1,:,:));
end
a1=((2*L+1)/(4*pi)); a2=factorial(L-M)/factorial(L+M); C=sqrt(a1*a2); % Normalization Factors
Ymn=C*Lmn.*exp(i*M*PHI); % Spherical Harmonic is theta part times phi part

% X,Y,Z - Cartesian coordinates of magnitude, squared, spherical harmonic surface points, [RES(1) x RES(2)]
[Xm,Ym,Zm]=sph2cart(PHI,THETA-pi/2,abs(Ymn).^2); % Spherical harmonics coordinates, [RES(1) x RES(2)]
[Xr,Yr,Zr]=sph2cart(PHI,THETA-pi/2,real(Ymn).^2);
[Xi,Yi,Zi]=sph2cart(PHI,THETA-pi/2,imag(Ymn).^2);

figure(1)
axis off; hold off;
  axes('position',[0.0500 0 0.2666 1]); 
    surf(Xm,Ym,Zm); 
    axis equal off; %rot3d;
    light; lighting phong; camzoom(1.3);
  axes('position',[0.3666 0 0.2666 1]); 
    surf(Xr,Yr,Zr); 
    axis equal off; %rot3d;
    light; lighting phong; camzoom(1.3);
    axes('position',[0.6833 0 0.2666 1]); 
  surf(Xi,Yi,Zi); 
    axis equal off; %rot3d;
    light; lighting phong; camzoom(1.3);
  axes('position',[0 0.9 1 0.1]); axis off;
    t(1)=text(0.50,0.25,'Spherical Harmonics','HorizontalAlignment','Center');
  axes('position',[0 0 1 0.1]); axis off;
    t(2)=text(0.20,0.25,['|Y^',num2str(M),'_',num2str(L),'|^2'],'HorizontalAlignment','Center');
    t(3)=text(0.50,0.25,['Real(Y^',num2str(M),'_',num2str(L),')^2'],'HorizontalAlignment','Center');
    t(4)=text(0.80,0.25,['Imag(Y^',num2str(M),'_',num2str(L),')^2'],'HorizontalAlignment','Center');
    
    
