% Schrodinger Waves Summed at One Specific Time
clear; clf;
% All values in atomic units
hbar=1; % constant of angular momentum
disp('** All Atomic Units **')
disp('Input values are for x=0 at t=0')
disp('do not stray too far from initial values' )
% input from dialog box
prompt = {'mass (m_e)',' examination time (aut)','momentum @t=0','momentum uncertainty @t=0'};
dlgtitle = 'Input';
fieldsize = [1 25; 1 25; 1 25; 1 30];
definput = {'1','0','2','0.6'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
m = str2num(answer{1}); % electron masses
t = str2num(answer{2}); % time
p0 = str2num(answer{3}); % initial momentum in atomic units
sp = str2num(answer{4}); % uncertainty in momentum

% spatial loop defining positions
jmax=500;
for j=1:jmax; x(j)=(j/jmax)*120-60; end % get position grid
dx=x(2)-x(1); % position increment
% loop defining momenta rel. to p0, corresponding kin. energies, weights
nmax=500;
for n=1:nmax
    p(n)=2*p0*n/nmax;  % momentum
    E(n)=p(n)^2/(2*m); % energy
    w(n)=exp(-(p(n)-p0)^2/(4*sp^2));  % weight
end
% define Schrodinger waves in terms of energy, momentum, time, position
for n=1:nmax
    for j=1:jmax; psi(j,n)=exp((-1i/hbar)*(E(n)*t-p(n)*x(j))); end
end
% weighted sum of waves
for j=1:jmax
    s=0;
    for n=1:nmax; s=s+w(n)*psi(j,n); end
    psisum(j)=s;
end
% Normalize sum wavepacket
N=0;
for j=1:jmax; N=N+psisum(j).*conj(psisum(j))*dx; end
disp(['check for normalization ',num2str(N)])
psisum=psisum./N^.5;

figure(1)
subplot(2,1,1)
% Schrodinger waves for plotting subset of momenta [variable ps not psi]
% only plot every 25th momentum wave
for j=1:jmax
   for n=1:18; ps(j,n)=w(n*25)*exp((-i/hbar)*(E(n*25)*t-p(n*25)*x(j))); end
end
% plot with offsets
for n=1:18; plot(x,real(ps(:,n))+2.5*n,'k'); hold on; end
set(gca,'FontSize',14)
xlabel('Position (Bohr)','FontSize',16)
ylabel('Amplitude with Offset','FontSize',16)
title('Selected and Weighted Schrodinger Waves','FontSize',16)
subplot(2,1,2)
plot(x,real(psisum),'k','LineWidth',1)
%plot(x,imag(psisum),'b','LineWidth',1)
%plot(x,psisum.*conj(psisum),'k','LineWidth',2)
set(gca,'FontSize',12)
xlabel('Position (Bohr)','FontSize',16)
ylabel('Amplitude','FontSize',16)
title(['Sum or Wavepacket at ',num2str(t),' aut'],'FontSize',16) 
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 6 10]);
print(1,'-dtiff','-r600','Adding_matter_waves.jpg')

