% Blackbody Radiation vs temperature and wavelength
% used in Figure 1.7
h=6.6260755e-34; % J s, Planck's constant
c=2.99792458e8; % m/s, speed of light in vacuum
k=1.380658e-23; % J/K, Boltmann's constant
lam=1e-6: 0.2e-6: 2.5e-5; % m, wavelength row arrayclear
[~,m]=size(lam);
T=[300 350 400 450]; % K, temperature row array
[~,iT]=size(T);
% calculate energy density per bandwidth at each temperature 
for i=1:iT % loop over temperature
    for n=1:m % loop over wavelength
        p(i,n)=((8*pi*h*c)/lam(1,n)^5)/(exp(h*c/(k*lam(1,n)*T(1,i)))-1); 
    end
end 
figure(1)
for k=1:iT
    plot(lam,p(k,:))
    text(0.7e-5,max(p(k,:)),[num2str(T(k)),' K'],'Fontsize',16)
    hold on
end
xlabel('Wavelength (m)','FontSize',14)
ylabel('Energy Density per Bandwidth (J/m^4)','FontSize',14)
set(gca,'FontSize',12)
