% Blackbody Radiation vs temperature and wavelength
% clf;
h=6.6260755e-34; % J s, Planck's constant
c=2.99792458e8; % m/s, speed of light in vacuum
k=1.380658e-23; % J/K, Boltmann's constant
lam=1e-7:0.1e-6:2.5e-5; % m, wavelength row array
[~,m]=size(lam);
T = input('enter a temperature in Kelvin (<5000 K) ');
% calculate energy density per bandwidth at T
for n=1:m % loop over wavelenth
    p(n)=((8*pi*h*c)/lam(1,n)^5) / (exp(h*c/(k*lam(1,n)*T))-1); % matrix array
end
% plot
figure(1)
plot(lam,p,'.-','MarkerSize',10)
text(0.7e-5,max(p),[num2str(T),' K'],'Fontsize',16); hold on
xlabel('Wavelength (m)','FontSize',14)
ylabel('Energy Density per Bandwidth (J/m^4)','FontSize',14)
set(gca,'FontSize',12)
