% Blackbody Radiation vs temperature and wavelength
% used in Figure 1.7
h=6.6260755e-34; % J s, Planck's constant
c=2.99792458e8; % m/s, speed of light in vacuum
k=1.380658e-23; % J/K, Boltmann's constant
lam=0.1e-6: 0.05e-6: 0.8e-5; % m, wavelength row arrayclear
[~,m]=size(lam);

disp('Input Four Temperatures (K) ')
prompt = {'T1 (K) 1000-4000 K ',' T2 (K) 1000-4000 K ', ' T3 (K) 1000-4000 K ',' T4 (K) 1000-4000 K '};
dlgtitle = 'Input';
fieldsize = [1 20; 1 20; 1 20; 1 20];
definput = {'1500','2000','2500','3000'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
T(1) = str2num(answer{1});
T(2) = str2num(answer{2});
T(3) = str2num(answer{3});
T(4) = str2num(answer{4});
[~,iT]=size(T);
% calculate energy density per bandwidth at each temperature
p=[];
for i=1:iT % loop over temperature
    for n=1:m % loop over wavelength
        p(i,n)=((8*pi*h*c)/lam(1,n)^5)/(exp(h*c/(k*lam(1,n)*T(1,i)))-1); 
    end
end
clf
C=get(gca,'colororder');
figure(1)
for k=1:iT
    plot(lam,p(k,:))
    text(0.15e-5,max(p(k,:)),[num2str(T(k)),' K'],'Fontsize',16,'Color',C(k,:))
    hold on
end
xlabel('Wavelength (m)','FontSize',14)
ylabel('Energy Density per Bandwidth (J/m^4)','FontSize',14)
set(gca,'FontSize',12)

