% complex numbers are used for waves
disp('using atomic units')
disp('1 aut = 2.418e-17 s')
disp('do not stray too far from initial values' )
prompt = {'E (Hartree) ',' max t (aut) '};
dlgtitle = 'Input';
fieldsize = [1 20; 1 20];
definput = {'-0.5','50'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
E = str2num(answer{1});
tmax = str2num(answer{2});
hbar=1; % atomic units
t=0:.1:tmax; % define a time range (in atomic units)
theta=-E*t/hbar;  % give theta in terms of E, t, and Hbar
f=exp(1i*theta); % temporal part of wavefuntion vs time
figure(1)
plot(t,real(f),'r',t,imag(f),'b')
xlabel('Time (Atomic Units)','FontSize',16)
ylabel('Amplitude','FontSize',16)
set(gca,'FontSize',14)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 8 3]);
print(1,'-dtiff','-r600','complex_number_as_waves.jpg')

