% Cv of copper metal vs temperature
% D.L. Martin, Can. J. Phys. 38:1 17-24 (1960)
R=8.31446; % gas constant in J/(K mol)
M2=xlsread('Martin_copper_T_Cp_Cv.xlsx'); % input T, Cp, Cv
Tv=M2(:,1);  % extract the temperature 
Cv=4.184*M2(:,3); % extract Cv and convert to J/(mol K) 
[n nc]=size(M2); % get the number of points in data set

% manual fit to Einstein formula using thetaE for characteristic temp.
% disp('Vary the characteristic Einstein temperature to get the best fit')
% thetaE = input('input the characteristic temperature (K) ');
% % thetaE=231;  % vary and minimize std clear

disp('Input Einstein and Debye Temperatures (K) ')
prompt = {'thetaE (K) ',' thetaD (K)'};
dlgtitle = 'Input';
fieldsize = [1 20; 1 20];
definput = {'231','315'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
thetaE = str2num(answer{1});
thetaD = str2num(answer{2});

for i=1:n % loop over points in data set, calc. Einstein formula at each T
    CvE(i,1)=3*R*(thetaE/Tv(i,1))^2*((exp(thetaE/(2*Tv(i,1)))...
        /(exp(thetaE/Tv(i,1))-1))^2);
end
sigEinstein=std(Cv-CvE); % standard deviation of comparison between data and Einstein
disp(['Einstein std. dev.= ',num2str(sigEinstein)])
% manual fit to Debye formula using thetaD for charateristic temp.
fun = @(x)  x.^4.*exp(x)./(exp(x)-1).^2; % define integrand 
% disp('Vary the Debye characteristic tempsrature to get the best fit')
% thetaD = input('input the characteristic temperature (K) ');
% % thetaD=315; % vary and minimize std 
for i=1:n % loop over points in data set, calculate Debye formula
    x2=thetaD/Tv(i,1);
    int_val=integral(fun,0,x2);
    CvD(i,1)=3*R*3*(Tv(i,1)/thetaD)^3*int_val ;
end
sigDebye=std(Cv-CvD); % standard deviation of comparison between data and Debye
disp(['Debye std. dev.= ',num2str(sigDebye)])

answer = questdlg('jpg of the plot?','Plot Menu','Yes','No','Yes');
graph=0; if strcmpi(answer,'Yes'); graph=1; end
figure(2)
plot([0 300], [3*R 3*R],'m')
hold on
plot(Tv,CvE,'b','LineWidth',1.5);
hold on
plot(Tv,CvD,'r','LineWidth',1.5);
hold on
plot(Tv,Cv,'.k','MarkerSize',15);
%axis([0 300.2 0 26])
text(20,24,'3R','FontSize',16,'Color','m')
text(210,18,'Cu(s)','FontSize',20)
text(95,13,['\theta_{Einstein}','= ',num2str(thetaE),' K'],...
    'FontSize',20,'Color',[0 0 1],'FontSize',16)
text(120,11,['\sigma=',num2str(sigEinstein)],'Color',[0 0 1])
text(95,8,['\theta_{Debye}','= ',num2str(thetaD),' K'],...
    'FontSize',20,'Color',[1 0 0],'FontSize',16)
text(120,6,['\sigma=',num2str(sigDebye)],'Color',[1 0 0])
xlabel('Temperature (K)','FontSize',14)
ylabel('C_{v} (J/(mol K))','FontSize',14)
ylim([0 27]);
set(gca,'FontSize',12)
if graph==1
    set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5]);
    print(2,'-dtiff','-r600','Copper_Cv.jpg')
end




    