% Modeling a Lorentzian function with Particle-in-a-Box Basis
disp('** All Atomic Units **')

% input from dialog box
prompt = {'width of box (bohr)',' position of Lorentzian (bohr)','half-width of Lorentzian (bohr)','# basis functions'};
dlgtitle = 'Input';
fieldsize = [1 25; 1 25; 1 30; 1 30];
definput = {'10','5','0.5','20'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
a = str2num(answer{1}); % width of box
x0 = str2num(answer{2}); % center of Lorentzian
d = str2num(answer{3}); % half-width of Lorentzian
N = str2num(answer{4}); % # of basis functions

x1=0:.05:a; % gridded row array of x variable for plotting
y1= 1./(1+((x1-x0)/d).^2); % digital fit function

% calculate the coefficient for each basis function
yfit=0*x1; % initialize the y values
for i=1:N
    fun=@(x)  sqrt(2/a)*sin(i*pi*x/a).*(1./(1+((x-x0)/d).^2)) ;
    c(i)= integral(fun,0,a); % each coefficient
    yfit=yfit+c(i)*sqrt(2/a)*sin(i*pi*x1/a); % add cont. of each basis fun.
end

figure(1)
subplot(2,1,2)
plot(x1,y1,'r') % plot the Lorentzian
hold on
plot(x1,yfit,'b') % plot the basis set model
xlabel('x','FontSize',14)
ylabel('Amplitude','FontSize',14)
set(gca,'FontSize',12)
subplot(2,1,1)
for i=1:N
    plot(x1,c(i)*sqrt(2/a)*sin(i*pi*x1/a)+i*0.2)
    hold on
end
xlim([0 a])
xlabel('x','FontSize',14)
ylabel('Amplitude','FontSize',14)
set(gca,'FontSize',12)
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 8])
print(1,'-dtiff','-r600',['weighted_basis_functions_',num2str(N),'.tif']) 

