clear; clf;
% DVRgeneral, Discrete Variable Representation
% J.V.Coe, 8/23/2012, modified 1/8/2018
% D.T. Colbert and W.H. Miller, J. Chem. Phys. 96, 1982-91 (1992).
% All atomic units
hbar=1; % hbar in atomic units
% Eoff=-100.22666; % E_eq of diatomic (hartree)
% reduced mass of HF is m1*m2(m1+m2)= 1822.888486 *
%    (1.00782503223*18.99840316273)/(1.00782503223+18.99840316273)   
%  ********** Dialog Box Input ********************
% input Well Parameters from Dialog Text Box
disp('Diatomic Morse Potential')
disp(' defaults set to HF ab initio fit')
disp('   solving 1000x1000 Ham. matrix')
disp('   plot takes the most time')
prompt = {'reduced mass (electron masses) :', ...
    'D dissociation energy (Hartree)', ...
    'beta, well curvature (1/bohr)', ...
    'Re, equlibrium bond distance (bohr)', ...
    'imax, # grid steps',...
    'min bond distance (bohr)',...
    'max bond distance (bohr)',...
    'wavefunction amplitude scale',...
    '# of states to plot',...
    'max energy on plot (Hartree)'};
dlgtitle = 'Input';
fieldsize = [1 20; 1 20; 1 20; 1 20; 1 20; 1 20; 1 20; 1 20; 1 20; 1 20];
definput = {'1744.605','0.2221','1.203','1.7444','1000','1.0','6.0','0.004','24','0.23'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
mu = str2num(answer{1}); 
D = str2num(answer{2});
beta = str2num(answer{3});
re = str2num(answer{4});
imax = str2num(answer{5});
xmin = str2num(answer{6});
xmax = str2num(answer{7});
ps= str2num(answer{8});
nE = str2num(answer{9});
Emax = str2num(answer{10});

% **************  define grid *********************************
dx=(xmax-xmin)/(imax-1); % increment, step size 
x=xmin:dx:xmax; % define grid of x-variable, start:step:end
gp=hbar^2/(2*mu*dx^2); % calculate grid parameter
% ********** input the potential function *****************************
for i=1:imax; V(i)=D*(1-exp(-beta*(x(i)-re)))^2; end % Morse potential
%**********************************************************************


% ********** kinetic energy matrix ************************************
T=zeros(imax,imax);
for i=1:imax
    for ip=1:imax
        T(i,ip)=gp*(pi^2)/3.0;
        if(ip~=i); T(i,ip)=gp*((-1)^(i-ip))*2/((i-ip)^2); end
    end   
end
% **********  potential energy matrix ********************************
Vh=zeros(imax,imax);
for i=1:imax
    for ip=1:imax
        if(i==ip); Vh(i,ip)=V(i); end
    end
end
% ********** Hamiltonian *********************************************
H=T+Vh;
% ********** Digonalize Hamiltonian **********************************
% Calculate eigenvalues (on diagaonal of E1), eigenvectors as columns of P
[P,E1]=eig(H);  
E=diag(E1); % Pick off the eigenvalues
% ********** Normalization of Wavefunctions *************************
N=0;
for i=1:imax; N=N+conj(P(i,1))*P(i,1)*dx; end
disp(['check for normalization, N= ',num2str(N)])
% normalize wavefunctions
P=P./(N^0.5);
% check for normalization
s=0;
for i=1:imax; s=s+conj(P(i,1))*P(i,1)*dx; end
disp(['after nomalization, N= ',num2str(s)])
% ********** Plot the results ***************************************
figure(1)
for n=1:nE % choose the number of states to plot 
    plot(x(:),V(:),'r'); hold on
    plot(x(:),E(n,1)*ones(imax),'-g'); hold on % green energy level lines
    plot(x(:),real(P(:,n))*ps+E(n,1),'b'); hold on % wavefunction amplitude
end
axis([xmin xmax -0.005 Emax]) % scale the plot
set(gca,'FontSize',12)
xlabel('r (bohr)','FontSize',14,'Interpreter','latex')
ylabel('$Re{\psi} \,(1/\surd bohr)\,or\, E (hartree)$','Interpreter','latex')
% set(gcf,'PaperUnits','inches','PaperPosition',[0 0 5 5])
% print(1,'-dtiff','-r600','DVR_HF.tif') 

