clear; clf;
% DVRgeneral, Discrete Variable Represenstation
% J.V.Coe, 1/21/2014
% D.T. Colbert and W.H. Miller, J. Chem. Phys. 96, 1982-91 (1992).
% All atomic units

% input through dialog box
disp('DVR 2D Squarewell')
disp('particle is an electron')
disp('atomic units')
prompt = {'a, box width, 0-a ','b, box width, 0-b', ...
    'nx, steps along x','steps along y','Well Depth (Hartree)'};
dlgtitle = 'Input';
fieldsize = [1 25; 1 25; 1 25; 1 25; 1 25];
definput = {'10','10','50','50','1000'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
a = str2num(answer{1}); % width of box along x
b = str2num(answer{2}); % width of box along y
nx=str2num(answer{3}); % number of steps along x coordinate
ny=str2num(answer{4}); % number of steps along y coordinate
V0=str2num(answer{5}); % well depth 

hbar=1; % hbar in atomic units
mu=1; % reduced mass in electron masses
dx=2*a/nx; % x increment, step size in position 
for i=1:nx; x(i)=i*dx-a/2-dx/2; end  % x coordinate grid
dy=2*b/ny; % y increment, step size in position 
for j=1:ny; y(j)=j*dy-b/2-dy/2; end % y coordinate grid

% input the potential function
for i=1:nx
    for j=1:ny
        V(i,j)=V0;
        if(0<=x(i)&&x(i)<=a&&0<=y(j)&&y(j)<=b); V(i,j)=0; end
    end
end

% grid parameters
gpx=hbar^2/(2*mu*dx^2); % x grid parameter
gpy=hbar^2/(2*mu*dy^2); % y grid parameter
% kinetic energy matrices
Tx=zeros(nx,nx);
for i=1:nx
    for ip=1:nx
        Tx(i,ip)=gpx*(pi^2)/3.0;
        if(ip~=i); Tx(i,ip)=gpx*((-1)^(i-ip))*2/((i-ip)^2); end
    end
end
Ty=zeros(ny,ny);
for j=1:ny
    for jp=1:ny
        Ty(j,jp)=gpy*(pi^2)/3.0;
        if(jp~=j); Ty(j,jp)=gpy*((-1)^(j-jp))*2/((j-jp)^2); end
    end
end

% Hamiltonian
H=zeros(nx*ny,nx*ny);
for i=1:nx
    for j=1:ny
        for ip=1:nx
            for jp=1:ny
                n=(j-1)*nx+i;
                np=(jp-1)*nx+ip;
                if(j==jp); H(n,np)=Tx(i,ip); end
                if(i==ip); H(n,np)=H(n,np)+Ty(j,jp); end
                if(i==ip&&j==jp); H(n,np)=H(n,np)+V(i,j); end
            end
        end
    end
end
        
% Calculate eigenvalues (on diagaonal of E1) and
% eigenvectors as columns of P
[P,E1]=eig(H);
% Pick off the eigenvalues from diagonal
E=diag(E1);

% Plot Results
figure(1)
for i=1:6
    subplot(6,1,7-i)
    plin=P(:,i);
    psi=reshape(plin,nx,ny);
    surfl(-psi)
    view(35,25)
    title([num2str(i),' E= ',num2str(E(i))])
    xlabel('X (Bohr)','Fontsize',14)
    ylabel('Y (Bohr)','Fontsize',14)
    zlabel('Amplitude','Fontsize',14)
end
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 6 16])
print(1,'-dtiff','-r600','psi_2D.jpg')