clear;
% Free Particle, all atomic units
x=[-6:.1:40]'; % range of position in Bohr
x0=0; % initial position
hbar=1;
m=1; % mass of an electron

disp('Free Particle in Time Steps')
disp('particle is an electron')
disp('atomic units')
disp('initial position is x=0')
disp('position uncertainty is s/sqrt(2)')
disp('momentum uncertainty is hbar/(s*sqrt(2)')
prompt = {'initial momentum ',' s is width parameter'};
dlgtitle = 'Input';
fieldsize = [1 20; 1 20];
definput = {'2','1.5'};
answer = inputdlg(prompt,dlgtitle,fieldsize,definput);
p0 = str2num(answer{1});
s = str2num(answer{2});

dx=s/sqrt(2); disp(['dx= ',num2str(dx)]) % position uncertainty
dp=hbar/(sqrt(2)*s); disp(['dp= ',num2str(dp)]) % momentum uncertainty
% loop through time
for i=1:10
    t(i)=i;
    xbar(i)=x0+p0*t(i)/m; % expectation value of position
    psi(:,i)= 1/(  pi^(1/4)*sqrt(s*(1+1i*hbar*t(i)/(m*s^2))))*...
        exp(-(x-x0-p0*t(i)/m).^2/(2*s^2*(1+1i*hbar*t(i)/(m*s^2)))).*...
        1i.*exp(1i*(p0*x-p0^2*t(i)/(2*m))/hbar); % wavepacket
end

% make a 3D plot
figure(1)
tone=x*0+1; % column array for time that matches x and psi
for i=1:10
    plot3(x,tone*t(i),conj(psi(:,i)).*psi(:,i))
    hold on
    plot3(xbar(i),t(i),0,'.k','MarkerSize',12)
end
xlabel('Position (bohr)','FontSize',14,'rot',18)
ylabel('Time (aut)','FontSize',14,'rot',-28)
zlabel('\psi*\psi','FontSize',14)
set(gca,'FontSize',12)
set(gca,'ydir','reverse')
zlim([0 .35])
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 6 6])
print(1,'-dtiff','-r600','free_particle_2.jpg') 
