% getting Associated Laguerre Functions from Laguerre Polynomials
% Generation of Table 2.3
syms x
% define Laguerre polynomials in physics convention
L0=1;
L1=1-x;
L2=2-4*x+x^2;
L3=6-18*x+9*x^2-x^3;
L4=24-96*x+72*x^2-16*x^3+x^4;
L5=120-600*x+600*x^2-200*x^3+25*x^4-x^5;

L=[L1 L2 L3 L4 L5]; % Laguerre Polynomials
n=[1 2 2 3 3 3]; % principal quantum number
el=[0 0 1 0 1 2]; % angular momentum quantum number

for i=1:6
    s=n(i)+el(i); % subscript of Associated Laguerre
    t=2*el(i)+1;  % superscript of Associated Laguerre
    Ls=L(s);
    disp(['s=',num2str(s),' t=',num2str(t),' n=',num2str(n(i)),...
        ' el=',num2str(el(i))])
    diff(Ls,t,x)
end